'use strict'

entityRegistry['device']['midiTransport'] = {
    init: () => {
        return {
            playMode: undefined,
            waitForNoteRelease: undefined,
        }
    },
    staticConfig: [
        { paramName: 'channel', displayName: 'Channel', type: 'int', defaultValue: 1, triggerInit: false, uiOptions: { min: 1, max: 16 }},
        { paramName: 'deviceInName', displayName: 'In Device Name', type: 'midiIn', defaultValue: '', triggerInit: false },
        { paramName: 'playNote', displayName: 'Play Note', type: 'int', defaultValue: -1, triggerInit: false, uiOptions: { min: -1, max: 127 }},
        { paramName: 'loopNote', displayName: 'Loop Note', type: 'int', defaultValue: -1, triggerInit: false, uiOptions: { min: -1, max: 127 }},
        { paramName: 'stopNote', displayName: 'Stop Note', type: 'int', defaultValue: -1, triggerInit: false, uiOptions: { min: -1, max: 127 }},
        { paramName: 'backBarNote', displayName: 'Back Bar Note', type: 'int', defaultValue: -1, triggerInit: false, uiOptions: { min: -1, max: 127 }},
        { paramName: 'forwardBarNote', displayName: 'Forward Bar Note', type: 'int', defaultValue: -1, triggerInit: false, uiOptions: { min: -1, max: 127 }},
        { paramName: 'backMarkerNote', displayName: 'Back Marker Note', type: 'int', defaultValue: -1, triggerInit: false, uiOptions: { min: -1, max: 127 }},
        { paramName: 'forwardMarkerNote', displayName: 'Forward Marker Note', type: 'int', defaultValue: -1, triggerInit: false, uiOptions: { min: -1, max: 127 }},
        { paramName: 'deviceOutName', displayName: 'Out Device Name', type: 'midiOut', defaultValue: '', triggerInit: false },
        { paramName: 'playStateNote', displayName: 'Play State Note', type: 'int', defaultValue: -1, triggerInit: false, uiOptions: { min: -1, max: 127 }},
        { paramName: 'loopStateNote', displayName: 'Loop State Note', type: 'int', defaultValue: -1, triggerInit: false, uiOptions: { min: -1, max: 127 }},
        { paramName: 'stopStateNote', displayName: 'Stop State Note', type: 'int', defaultValue: -1, triggerInit: false, uiOptions: { min: -1, max: 127 }},
    ],
    actions: {
        engage: (engage) => {
        },
        update: (self, config) => {
            const {
                channel,
                deviceInName,
                playNote,
                loopNote,
                stopNote,
                backBarNote,
                forwardBarNote,
                backMarkerNote,
                forwardMarkerNote,
                deviceOutName,
                playStateNote,
                loopStateNote,
                stopStateNote,
            } = {...config}

            // const deviceInName = 'Steinberg CMC-TP Port1'
            // const deviceOutName = 'Steinberg CMC-TP Port1'

            // Input
            if (self.waitForNoteRelease && midiIsNoteOn(deviceInName, channel, self.waitForNoteRelease)) {
                // Wait until last key released
            } else {
                self.waitForNoteRelease = false

                if (playNote !== -1 && midiIsNoteOn(deviceInName, channel, playNote)) {
                    transport.setIsPlaying(true, false)
                    self.waitForNoteRelease = playNote
                }
                if (loopNote !== -1 && midiIsNoteOn(deviceInName, channel, loopNote)) {
                    transport.setIsPlaying(true, true)
                    self.waitForNoteRelease = loopNote
                }
                if (stopNote !== -1 && midiIsNoteOn(deviceInName, channel, stopNote)) {
                    transport.setIsPlaying(false)
                    self.waitForNoteRelease = stopNote
                }
                if (backBarNote !== -1 && midiIsNoteOn(deviceInName, channel, backBarNote)) {
                    transport.seekRelativeBar(-1)
                    self.waitForNoteRelease = backBarNote
                }
                if (forwardBarNote !== -1 && midiIsNoteOn(deviceInName, channel, forwardBarNote)) {
                    transport.seekRelativeBar(+1)
                    self.waitForNoteRelease = forwardBarNote
                }
                if (backMarkerNote !== -1 && midiIsNoteOn(deviceInName, channel, backMarkerNote)) {
                    transport.seekRelativeMarker(-1)
                    self.waitForNoteRelease = backMarkerNote
                }
                if (forwardMarkerNote !== -1 & midiIsNoteOn(deviceInName, channel, forwardMarkerNote)) {
                    transport.seekRelativeMarker(+1)
                    self.waitForNoteRelease = forwardMarkerNote
                }
            }

            // Output
            if (self.playMode !== transport.getPlayMode()) {
                self.playMode = transport.getPlayMode()
                if (playStateNote !== -1) {
                    midiSendNoteOn(deviceOutName, channel, playStateNote, self.playMode === 'play' ? 127 : 0)
                }
                if (loopStateNote !== -1) {
                    midiSendNoteOn(deviceOutName, channel, loopStateNote, self.playMode === 'loop' ? 127 : 0)
                }
                if (stopStateNote !== -1) {
                    midiSendNoteOn(deviceOutName, channel, stopStateNote, self.playMode === 'stop' ? 127 : 0)
                }
            }
        },
    }
}
